; Dialog1.asm - demonstrates a simple dialog box
;
; Though this is an extremely crude dialog box and has very simple controls
; on it, the principles remain identical for dialogs with large numbers of
; controls on them - they may look more complex, but they're not and you
; handle them just the same way.
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

%include "Dialog1.ash"

[BITS 32]
[section .text]

ddglobal _gbl_hInstance

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	eax, .hInstance
	mov	._gbl_hInstance, eax
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Dialog box',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	endlocals
	;
	CallbackPrologue
	;
	switch .message
		case WM_PAINT
			;
			; Display a message on the window
			;
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			TEXTlocal szWndText, 'Left-click to display dialog box',0
			sc DrawText, ._hdc, .szWndText, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax, eax
			break
		case WM_LBUTTONUP
			;
			; To display the dialog box we call DialogBoxParam which takes five parameters:
			;
			;   1. Application instance handle
			;   2. Address of dialog box template name
			;   3. Owner window handle
			;   4. Address of dialog box procedure
			;   5. Initialisation value (passed to the dialog box via WM_INITDIALOG)
			;
			TEXTlocal _szMyDialog, 'MYDIALOG',0
			sc DialogBoxParam, ._gbl_hInstance, ._szMyDialog, .hwnd, _DlgProc, 5
			;
			; And that's all it takes to display a dialog box - all the dialog
			; controls are handled by the dialog box procedure
			;
			xor	eax, eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax, eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc
;
;-----------------------------------------------------------------------
;
; Dialog box procedure - this works just like a normal window procedure
; except the switch handling is slightly different. Essentially, you
; return non-zero if you handled the message or zero if you want Windows
; to handle the message for you.
;
; There is one exception to this rule - the WM_INITDIALOG message. See
; below for what you should do in this case.
;
; You'll find that processing dialog box messages is just as straightforward
; for a normal window procedure. Indeed, you'll probably have more problems
; getting your dialogs looking nice than writing the code for them :)
;
proc _DlgProc, hwndDlg, message, wParam, lParam
	;
	CallbackPrologue
	;
	switch .message
		case WM_INITDIALOG
			;
			; WM_INITDIALOG is sent when the dialog box is first created,
			; with lParam holding the initialisation value passed.
			; You return true unless you want to explicitly set the
			; focus to a particular control on the dialog box (ie
			; by SetFocus)
			;
			mov	eax, TRUE
			break
		case WM_COMMAND
			;
			; WM_COMMAND is sent whenever a control sends a message
			;
			; wParam holds two values in this case:
			;
			;   loword - identifier of control, menu or accelerator
			;   hiword - notification code
			;
			mov	eax, .wParam
			switch ax
				case IDOK
					;
					; Ok button, so end the dialog by calling EndDialog
					; which takes two parameters:
					;
					;   1. Handle of dialog box to end
					;   2. Value to be returned to the procedure that created
					;      the dialog box, eg by DialogBoxParam
					;
					sc EndDialog, .hwndDlg, 0
					;
					; tell Windows we handled the message
					;
					mov	eax, 1
					break
				case IDCANCEL
					;
					; Cancel button, so do the same as the Ok button
					;
					sc EndDialog, .hwndDlg, 0
					mov	eax, 1
					break
				default
					;
					; Let Windows handle things
					;
					mov	eax, 0
			switchend
			break
		default
			;
			; Let windows handle the message
			;
			mov	eax, 0
	switchend
	;
	CallbackEpilogue
endproc
;
;-----------------------------------------------------------------------
;
[section .bss]

[section .data]
